-- new script file

local coAttWave = {}
local mission = {}

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("coAttLT")
	self:AddTriggerTarget("coAttST")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
  
    if not self.loaded then
			self.active = false
      self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
			self.coAtt = 0
    end
  
    mission.enemy = Citadels.GetPlayer(1)
    --self.attackPoint = Game:GetEntity('attackDetectorLT'):GetPosition()
  end
  
  if self.active then
    InitializeWave(self)
    AttackWave(self)
    self.active = false
  end  
end

function InitializeWave(self)
	if self.coAtt == 1 then
		coAttWave['unit_L_archer_L1'] = self.baseCount * 0.06
		coAttWave['unit_L_rider_L1'] = self.baseCount * 0.04
		coAttWave['unit_L_fman_L1'] = self.baseCount * 0.06
		self.spawnPos = Game:GetEntity("counterPos-1"):GetPosition()
	elseif self.coAtt == 2 then
		coAttWave['unit_L_archer_L1'] = self.baseCount * 0.09
		coAttWave['unit_L_fman_L1'] = self.baseCount * 0.06
		self.spawnPos = Game:GetEntity("counterPos-2"):GetPosition()
	else 
		Debug:Log("Attack failed to initialize")
	end
end


function AttackWave(self)
  for prefab,ammount in pairs(coAttWave) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  --mission.enemy:AttackGroupAddWayPoints(self.attackPoint)
  mission.enemy:AttackGroupCommit(1, self.spawnPos, 20)
end

function OnTrigger(self, source, target)
  if target == "coAttLT" then
	  self.coAtt = 1
	elseif target == "coAttST" then
		self.coAtt = 2
  end
	self.active = true
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  self.loaded = true
	  self.active = ar:Read()
    self.baseCount = ar:Read()
    self.coAtt = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.active)
    ar:Write(self.baseCount)
    ar:Write(self.coAtt)
  end  
end
